﻿using System;
using System.Web;
using System.Text.RegularExpressions;
using System.Web.Security.AntiXss;
using VIRP_WEB.BaseCode;
using VIRP.EFR.DAL;
using VIRP.EFR.BLL;

namespace VIRP_WEB.Custom.EFR
{
    public partial class DoDFragmentAnalyteDelete : EfrBasePage
    {
        private DoDFragmentDB manager = new DoDFragmentDB();
        protected readonly string DoDFragmentPage = "~/Custom/EFR/DoDFragment/DoDFragment.aspx?patientId=";
        private string pFullName = "";

        protected override void Page_Load(object sender, EventArgs e)
        {
            DisplayPatientInfo();
            ReplacePageTitle("Patients > Patient Lookup > Workflows > DoD Fragment Data > " + pFullName);

            HiddenFieldPatientID.Value = AntiXssEncoder.HtmlEncode(Request.QueryString["patientId"], false);
            HiddenFieldAnalyteID.Value = AntiXssEncoder.HtmlEncode(Request.QueryString["dodFragmentAnalyteId"], false);

            DOD_FRAGMENT_DETAIL analyte = manager.GetFragmentAnalyteById(Helpers.GetIntFromString(HiddenFieldAnalyteID.Value));
            //analyte.SetAsChangeTrackingRoot();
            //analyte.SetAsDeleteOnSubmit();

            //manager.Update(analyte);
            DOD_FRAGMENT_DETAILManager.Delete(HttpContext.Current.User.Identity.Name, UserSession.CurrentRegistryId, analyte.DOD_FRAGMENT_DETAIL_ID);

            ResponseRedirect(DoDFragmentPage, GetQueryStringValue(HiddenFieldPatientID.Value));
        }

        private void DisplayPatientInfo()
        {
            if (!string.IsNullOrEmpty(BaseCode.Helpers.AntiXssEval(Request.QueryString["patientId"])))
            {
                int patientId = Convert.ToInt32(BaseCode.Helpers.AntiXssEval(Request.QueryString["patientId"]));

                VIRP.CRS.BO.PATIENT p = VIRP.CRS.BLL.PATIENTManager.GetItem(CurrentUser, CurrentRegistryId, patientId);
                VIRP.CRS.BO.PATIENT_REG pr = VIRP.CRS.BLL.PATIENT_REGManager.GetItem(CurrentUser, CurrentRegistryId, patientId);

                if (p != null)
                {
                    pFullName = p.FULL_NAME;
                }
            }
        }

        private string GetQueryStringValue(string patientID)
        {
            string vldPatientId = string.Empty;
            try
            {
                if (IsQueryStringValid(patientID))
                {
                    vldPatientId = patientID.ToString();
                }
            }
            catch (Exception ex)
            {
                ServiceInterfaceManager.LogError("Error parsing request data.: " + ex.ToString(), String.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), HttpContext.Current.User.Identity.Name, UserSession.CurrentRegistryId);
            }
            return vldPatientId;
        }

        private bool IsQueryStringValid(string patientID)
        {
            bool isStringValid = false;
            if (patientID != null)
            {
                if (Regex.IsMatch(patientID.ToString(), "^[a-zA-Z0-9]*$"))
                {
                    isStringValid = true;
                }
            }
            return isStringValid;
        }

        private void ResponseRedirect(string destination, string queryString)
        {
            try
            {
                string queryStringValue = string.Empty;
                if (queryString != null)
                {
                    queryStringValue = AntiXssEncoder.UrlEncode(queryString);
                }

                string destinationUrl = string.Concat(destination, queryStringValue);
                string currentHost = Request.Url.Host;
                if (Helpers.IsDestinationUrlLocal(destinationUrl, currentHost))
                {
                    Server.Transfer(destinationUrl);
                }
            }
            catch (Exception ex)
            {
                ServiceInterfaceManager.LogError("Failure in to redirect to Export page: - DOD Fragment page.: " + ex.ToString(), String.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), HttpContext.Current.User.Identity.Name, UserSession.CurrentRegistryId);
            }
        }
    }
}